<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../../../../gUtil/GestoreUpload.php";
    include "../../../../gUtil/ElaboratoreImmagini.php";
    include "../classi/Mappa.php";
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $occorrenza = new Mappa($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $occorrenza = new Mappa($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $occorrenza->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $occorrenza->setIndirizzo(filter_input(INPUT_POST,"indirizzo",FILTER_SANITIZE_NUMBER_INT));
            $occorrenza->setTipo(filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_STRING));
            $occorrenza->setHtml(filter_input(INPUT_POST,"html",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setJavascript(filter_input(INPUT_POST,"javascript",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setLatitudine(filter_input(INPUT_POST,"latitudine",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
            $occorrenza->setLongitudine(filter_input(INPUT_POST,"longitudine",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
            $occorrenza->crea();
            header("Location: ../creaMappa.php?id={$occorrenza->getId()}&status=200");
            break;
        case 'modifica':
            $occorrenza->caricaDatiDalDatabase();
            $occorrenza->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $occorrenza->setIndirizzo(filter_input(INPUT_POST,"indirizzo",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setTipo(filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_STRING));
            $occorrenza->setHtml(filter_input(INPUT_POST,"html",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setJavascript(filter_input(INPUT_POST,"javascript",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setLatitudine(filter_input(INPUT_POST,"latitudine",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
            $occorrenza->setLongitudine(filter_input(INPUT_POST,"longitudine",FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION));
            $occorrenza->modifica();
            header("Location: ../creaMappa.php?id={$occorrenza->getId()}&status=250");
            break;
        case 'modificaImmagine':
            $tipiFileAmmessi = array("image/png","image/jpeg","image/gif");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../../../../immagini/altro", 0);
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["fileElaborati"]==1) {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }
                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }
            }
            else {
                $percorsoFoto = "";
            }
            $occorrenza->cambiaImmagine($percorsoFoto);
            
            // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
            if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                }
            }

            if($impostazioni["generaThumbnail"]=="si") {
                $percorsoFileThumbnail = str_replace("immagini/","immagini/thumbnail/",$esitoUpload["percorso"]);
                $percorsoThumbnail = str_replace("../","",$percorsoFileThumbnail);
                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaThumbnail"], $percorsoFileThumbnail);
            }
            
            echo "../../../$percorsoFoto";
            break;
        case 'elimina':
            $occorrenza->elimina();
            echo "ok";
            break;
        case 'duplica':
            $occorrenza->caricaDatiDalDatabase();
            $idNuovaForm = $occorrenza->duplica();
            header("Location: ../creaMappa.php?id={$idNuovaForm}&status=220");
            break;
    }
